;+
; function load_faam_core, file, variables=variables
;
; Loads v002 core data files from the FAAM research aircraft.
; RETURNS:
; A structure containing the data from the file
; INPUT PARAMETER
; file  The name of the file to be read. Should follow the pattern:
;           /path/core_faam_YYYYMMDD_v002_rN_FFFF*.nc
;       where - YYYYMMDD is the date of the flight
;             - v002 indicates the file is version 2
;             - N is the revision number of the processing
;             - FFFF is the flight number
; KEYWORDS
; variables=variables A list of variables to read from the file. 
;       Default is to read everything
; HISTORY
; 18/11/08 G Thomas: Orginal
; 02/12/08 G Thomas: Work around for the bug in FAAM data, whereby not
;                    all invalid gps lat/lon data is set to the
;                    _fillvalue, but sometimes is just set to zero.
;                    NB. This is not a complete fix.... need to check
;                    other GPS data.
;-

function load_faam_core, file, variables=variables, globattr=globattr, $
                         varattr=varattr
  
  tmp = read_ncdf(file, out, variable_list=variables, /quiet,          $
                  global_attributes=globattr,                          $
                  variable_attributes=varattr)
; Note that not all missing GPS lat/lon data has the missing value 
; (faam.lat_gps._fillvalue=-9999.0) assigned, some are simply = 0!
  if n_elements(out.lat_gps) gt 0 and n_elements(out.lon_gps) gt 0 $
  then begin
     badgps = where(out.lat_gps.data eq 0.0 and out.lon_gps.data eq 0.0)
     out.lat_gps.data[badgps] = out.lat_gps._fillvalue
     out.lon_gps.data[badgps] = out.lon_gps._fillvalue
  endif

  if tmp eq 1 then return, out else begin
     print,'LOAD_FAAM_CORE: Error reading file: ',file
     return, {null: 0}
  endelse

end
