PRO L1C_HIROS, L1BFIL, L1CFIL, ALTMAX=ALTMAX, ALTMIN=ALTMIN
;
; VERSION
    VERSID = '14JUN24' ; Add noise as a spectrum rather than a scalar
;   VERSID = '24JUL23' ; Format v3.3, add GEO grid type, extra MW header record
;   VERSID = '26JUN23' ; Add ALT_OFFSET to L1C output
;   VERSID = '11APR23' ; Add ALT_TREND and ALT_QUAD to L1C output
;   VERSID = '13MAY22' ; Add ALTMAX, ALTMIN keyword arguments
;   VERSID = '18JAN22' ; Renamed from make_l1c_hiros.pro to l1c_hiros.pro
;   VERSID = '12JAN22' ; Change RAD_CURV to RAD_CURVE
;   VERSID = '02DEC21' ; Change Noise data structure in L1B
;   VERSID = '22JUL21' ; Change L1B variable names 
;   VERSID = '15JUL21' ; Original
;
; DESCRIPTION
;   L2 Preprocessor to convert HIROS L1B to L1C, suitable for MORSE input.
;
; ARGUMENTS
;   L1BFIL String  I  Name of input L1B file
;   L1CFIL String  I  Name of output L1C file
;
; EXTERNAL
;   Fnc READ_L1B_HIROS  Read L1B HIROS data
;   Fnc HMS             Return string HHMMSS for millisecs within day
;   Fnc YMD             Return string YYYYMMDD for Julian day#
;
; USAGE
;  eg: L1C_HIROS, 'l1b_hiros.nc', 'hiros.l1c' 
;
L1B = READ_L1B_HIROS ( L1BFIL ) 
NALT = L1B.NALT
NMIC = L1B.NMIC

IF NOT KEYWORD_SET ( ALTMIN ) THEN ALTMIN = -999.0
IF NOT KEYWORD_SET ( ALTMAX ) THEN ALTMAX = 999.0

; Check that all microwindows have same resolution
FOR IMIC = 1, NMIC-1 DO BEGIN
  IF L1B.MIC_RES[IMIC] NE L1B.MIC_RES[0] THEN MESSAGE, $
    'F-L1C_HIROS: Microwindows have different spectral resolutions'
ENDFOR

OPENW, LUNL1C, L1CFIL, /GET_LUN
PRINTF, LUNL1C, '! MORSE l1c file created by l1c_hiros.pro v' + VERSID
PRINTF, LUNL1C, '       3.4                         (=format id)'
PRINTF, LUNL1C, 2, L1B.MIC_RES[0], $
  '(2=limb tra, resln)', FORMAT='(I10,F10.4,15X,A)'
PRINTF, LUNL1C, L1B.INSTRUMENT, L1B.SATELLITE, '(=Instrument,satellite)', $
  FORMAT='(2A10,15X,A)'

; Establish various time/date forms
JDAY = L1B.JULIAN_DAY[0]
PRINTF, LUNL1C, YMD(JDAY), JDAY, '(=nominal date, day# since 1Jan2000)', $
  FORMAT='(A10,I10,15X,A)'

PRINTF, LUNL1C, L1B.ORBIT, HMS(L1B.MILLISECONDS[0]), $
                           HMS(L1B.MILLISECONDS[NALT-1]), $
 '(=Orbit#, Event Start, End HHMMSS)', FORMAT='(5X,I5.5,A10,A10,5X,A)'

NSCN = 1             ; No. of profiles in file
PRINTF, LUNL1C, NSCN, '(=No.scans)', FORMAT='(I10,25X,A)'

IDXALT = WHERE ( L1B.ALTITUDE GE ALTMIN AND L1B.ALTITUDE LE ALTMAX, NIDX )

PRINTF, LUNL1C, NIDX, 'GEO', '(=No.sweeps per scan, then nominal alts [km])', $
  FORMAT='(I10,A10,15X,A)'

; In L1C altitudes are always high to low
IF L1B.SUNRISE THEN BEGIN
  I = IDXALT[NIDX-1]
  J = IDXALT[0]
  K = -1
  PRINTF, LUNL1C, REVERSE(L1B.ALTITUDE[IDXALT]), FORMAT='(10F8.3)'
ENDIF ELSE BEGIN
  I = IDXALT[0]
  J = IDXALT[NIDX-1]
  K = 1
  PRINTF, LUNL1C, L1B.ALTITUDE[IDXALT], FORMAT='(10F8.3)'
ENDELSE

IF L1B.ALTITUDE[I] LE L1B.ALTITUDE[J] THEN MESSAGE, $
  'F-L1C_HIROS: L1B altitude sequence does not match SUNRISE flag'

ISCN = 1
PRINTF, LUNL1C, ISCN, '(=Scan#)', FORMAT='(I10,5X,A)'

LST = 0.0
SZA = 90.0
CLDRAD = 0.0
CLDIDX = 0.0

; L1B contains linear altitude trend from low freq to high freq but this
; remains the same even if sunrise data sequence is reversed

FOR IALT = I, J, K DO BEGIN
  PRINTF, LUNL1C, '!yyyymmdd hhmmss  millisec Scn Swp   Lat     Lon' + $
                    '   LST     SZA   CldRad CldIdx'
  ALT = L1B.ALTITUDE[IALT]
  PRINTF, LUNL1C, ' ' + YMD ( L1B.JULIAN_DAY[IALT] ) + ' ' + $
                  HMS ( L1B.MILLISECONDS[IALT] ) + $
                  STRING ( L1B.MILLISECONDS[IALT], FORMAT='(I10)' ) + $
                  STRING ( ISCN, FORMAT='(I4)' ) + $
                  STRING ( IALT+1, FORMAT='(I4)' ) + $
                  STRING ( L1B.LATITUDE[IALT], FORMAT='(F7.2)' ) + $
                  STRING ( L1B.LONGITUDE[IALT], FORMAT='(F8.2)' ) + $
                  STRING ( LST, FORMAT='(F7.3)' ) + $
                  STRING ( SZA, FORMAT='(F7.2)' ) + $
                  STRING ( CLDRAD, FORMAT='(F8.1)' ) + $
                  STRING ( CLDIDX, FORMAT='(F7.2)' ) 
;                  12312345678123456781234567891234567812345678            
  PRINTF, LUNL1C, '!NMW GeoNom  GeoSwp  RadCrv'
  PRINTF, LUNL1C, STRING ( NMIC, FORMAT='(I3)' ) + $
                  STRING ( ALT, FORMAT='(F8.3)' ) + $
                  STRING ( ALT, FORMAT='(F8.3)' ) + $
                  STRING ( L1B.RAD_CURVE[IALT], FORMAT='(F9.3)' ) 
  FOR IMIC = 0, NMIC-1 DO BEGIN
    PRINTF, LUNL1C, '! Label   NPts      WnoMin      WnoMax     Noise' + $
                    '    Offset     Drift Quadratic'
    PRINTF, LUNL1C, STRING ( L1B.MIC_LAB[IMIC],        FORMAT='(A-8)' ), $
                    STRING ( L1B.MIC_NPT[IMIC],        FORMAT='(I6)' ), $
                    STRING ( L1B.MIC_MIN[IMIC],        FORMAT='(F12.4)' ), $
                    STRING ( L1B.MIC_MAX[IMIC],        FORMAT='(F12.4)' ), $
                    STRING ( -1,                       FORMAT='(F10.4)' ), $  
                    STRING ( L1B.ALT_OFFSET[IALT,IMIC], FORMAT='(F10.3)' ), $
                    STRING ( L1B.ALT_TREND[IALT,IMIC], FORMAT='(F10.3)' ), $
                    STRING ( L1B.ALT_QUAD[IALT,IMIC],  FORMAT='(F10.3)' ) 
    NPT = L1B.MIC_NPT[IMIC]
    PRINTF, LUNL1C, L1B.TRANSMITTANCE[0:NPT-1,IALT,IMIC]
    PRINTF, LUNL1C, L1B.NOISE[0:NPT-1,IMIC]
  ENDFOR

ENDFOR

FREE_LUN, LUNL1C

END

l1c_hiros, 'l1b_hiros.nc', 'hiros.l1c', ALTMIN=5, ALTMAX=60

end
