PRO MAKE_L2, RTVFIL, NCFILE
;
; VERSION
    VERSID = '12OCT22' ; AD Original. Based on part of make_l1b_hiros.pro
;
; DESCRIPTION
;   Create L2 netCDF file from MORSE .rtv file
;
; ARGUMENTS
;   RTVFIL  String  I  Input .rtv filename
;   NCFILE  String  I  Output netCDF filename

; Read contents of .rtv file into structure
RTV = READ_RTV ( RTVFIL ) 

; open output file - NB "/clobber" above allows overwriting of existing file
; nedd netcdf4 in order to support 'string' variables such as 'satellite'
NCID = NCDF_CREATE ( NCFILE, /CLOBBER, /NETCDF4_FORMAT )

; define global attributes
NCDF_ATTPUT, NCID, 'Title',  RTV.HDR.HDR2,   /STRING, /GLOBAL
NCDF_ATTPUT, NCID, 'Created', SYSTIME(0), /STRING, /GLOBAL
NCDF_ATTPUT, NCID, 'Source', $
  'Created using make_l2.pro v' + VERSID,  /STRING, /GLOBAL

; define dimensions
NLEV = RTV.HDR.NLEV
NHGT_DID = NCDF_DIMDEF ( NCID, 'NHgt', NLEV )   ; should return 0

; Assign scalar variables
SAT_VID = NCDF_VARDEF ( NCID, 'Satellite', /STRING ) 
INS_VID = NCDF_VARDEF ( NCID, 'Instrument', /STRING ) 
ORB_VID = NCDF_VARDEF ( NCID, 'Orbit', /LONG )

SUN_VID = NCV_DEF ( NCID, 'sunrise' ) 
YMD_VID = NCV_DEF ( NCID, 'ymd' )
HMS_VID = NCV_DEF ( NCID, 'hms' )
DAY_VID = NCV_DEF ( NCID, 'julian_day' )
LAT_VID = NCV_DEF ( NCID, 'lat' ) 
LON_VID = NCV_DEF ( NCID, 'lon' ) 

HGT_VID = NCDF_VARDEF ( NCID, 'hgt', [NHGT_DID] )

NPRF = RTV.HDR.NPRF
PRF_VID = LONARR(NPRF)
FOR IPRF = 0, NPRF-1 DO BEGIN
  LABEL = RTV.HDR.LABPRF[IPRF]
  IF RTV.HDR.SCAPRF[IPRF] THEN PRF_VID[IPRF] = NCV_DEF ( NCID, LABEL ) $
                ELSE PRF_VID[IPRF] = NCV_DEF ( NCID, LABEL, [NHGT_DID] )
ENDFOR

; change from "define" mode to "data" mode
NCDF_CONTROL, NCID, /ENDEF

; write data

; Scalar data
NCDF_VARPUT, NCID, SAT_VID, RTV.HDR.SATELLITE 
NCDF_VARPUT, NCID, INS_VID, RTV.HDR.INSTRUMENT
NCDF_VARPUT, NCID, ORB_VID, RTV.HDR.ORBIT
NCDF_VARPUT, NCID, SUN_VID, RTV.HDR.IGEOM GT 0
NCDF_VARPUT, NCID, YMD_VID, RTV.PIX.YMD
NCDF_VARPUT, NCID, HMS_VID, RTV.PIX.HMS
NCDF_VARPUT, NCID, LAT_VID, RTV.PIX.LAT
NCDF_VARPUT, NCID, LON_VID, RTV.PIX.LON

NCDF_VARPUT, NCID, HGT_VID, RTV.HDR.LEVGRD
FOR IPRF = 0, NPRF-1 DO BEGIN
  IOF = RTV.HDR.IOFPRF[IPRF]
  NLV = RTV.HDR.NLVPRF[IPRF]
  IF RTV.HDR.SCAPRF[IPRF] THEN $
    NCDF_VARPUT, NCID, PRF_VID[IPRF], RTV.PIX.DAT[IOF] $
  ELSE BEGIN
    PRFDAT = FLTARR(NLEV)
    IDXLEV = RTV.HDR.ILVPRF[IOF:IOF+NLV-1]
    PRFDAT[IDXLEV] = RTV.PIX.DAT[IOF:IOF+NLV-1]
    NCDF_VARPUT, NCID, PRF_VID[IPRF], PRFDAT
  ENDELSE
ENDFOR

NCDF_CLOSE, NCID

END

make_l2, 'hsdi_pt.rtv',    'l2_hsdi_pt.nc'
make_l2, 'hsdi_aer01.rtv', 'l2_hsdi_aer01.nc'
make_l2, 'hiros_pt.rtv',   'l2_hiros_pt.nc'
make_l2, 'hiros_ch4.rtv',  'l2_hiros_ch4.nc'
end

