from l2_class import L2
from read_rtv import read_rtv
from datetime import datetime

def make_l2 ( rtvfil, ncfil ):
  """ Create Create L2 netCDF file from MORSE .rtv file

  Version
    20NOV24 AD Correction: .latitude, .longitude not .lat, .lon
    30JUL24 AD Adapted from IDL module

  Arguments
    rtvfil  str  : Input .rtv filename
    ncfil   str  : Output netCDF filename

  """

  VERSID = '20NOV24'

  # Read .rtv file contents
  hdr,pix = read_rtv ( rtvfil ) 

  l2 = L2()

  # Global attributes
  l2.title = hdr['hdr2']
  l2.created = str(datetime.now) 
  l2.source = 'Created using make_l2.py v' + VERSID

  # define dimensions
  l2.nhgt = hdr['nlev']

  # Assign scalar variables
  l2.satellite  = hdr['satellite']
  l2.instrument = hdr['instrument']
  l2.orbit      = hdr['orbsta']
  l2.julian_day = hdr['daysta']
  l2.hgt        = hdr['levgrd']
  l2.labprf     = hdr['labprf']
  l2.ymd        = pix['ymd'][0]
  l2.hms        = pix['hms'][0]
  l2.latitude   = pix['lat'][0]
  l2.longitude  = pix['lon'][0]
  nprf = hdr['nprf']
  l2.profiles = {}
  for prf in hdr['labprf']:
    l2.profiles[prf] = pix[prf][0]

  l2.write ( ncfil ) 

#make_l2 ( 'hsdi_pt.rtv', 'test.nc' )
#make_l2, 'hsdi_aer01.rtv', 'l2_hsdi_aer01.nc'
#make_l2, 'hiros_pt.rtv',   'l2_hiros_pt.nc'
make_l2 ( 'hiros_ch4.rtv',  'l2_hiros_ch4.nc' )
