FUNCTION NCV_DEF, NCID, VAR, DIMS, NAME=NAME
;
; VERSION
;   22JUL24 AD Add 'csq'
;   05AUG22 AD Add 'inf' variables
;   19JUL22 AD Rewritten.
;   17MAR22 AD Original. Extracted from ncvar
;
; DESCRIPTION
;   IDL function to define NetCDF variables and assign attributes
;   VAR needs to be one of a recognised list.

SCALAR = N_PARAMS ( ) EQ 2
LVAR = STRLOWCASE ( VAR ) 
UNITS = ''
IF NOT KEYWORD_SET ( NAME ) THEN NAME = LVAR

QAL = ''
QALLST = [ '_csq', '_dfs', '_inf', '_res', '_sd' ]
FOR IQAL = 0, N_ELEMENTS ( QALLST ) - 1 DO BEGIN
  IF STRPOS ( LVAR, QALLST[IQAL] ) GT 0 THEN BEGIN
    QAL = QALLST[IQAL]
    IPOS = STRPOS ( LVAR, QAL ) 
    LVAR = STRMID ( LVAR, 0, IPOS ) 
    BREAK
  ENDIF
ENDFOR

CASE LVAR OF 
  'aerosol': ATT = {  TYPE:'F', $
                 LONG_NAME:'aerosol extinction', $
                     UNITS:'per_km' }
  'ch4':     ATT = {  TYPE:'F', $
                 LONG_NAME:'methane mole fraction', $
                     UNITS:'ppmv' }
  'cld':     ATT = {  TYPE:'F', $
                 LONG_NAME:'cloud fraction', $
                     UNITS:'percent' }
  'co2(3)':     ATT = {  TYPE:'F', $
                 LONG_NAME:'18oco rescaled mole fraction', $
                     UNITS:'ppmv' }
  'h2o':     ATT = {  TYPE:'F', $
                 LONG_NAME:'water vapour mole fraction', $
                     UNITS:'ppmv' }
  'hdo':     ATT = {  TYPE:'F', $
                 LONG_NAME:'hdo rescaled mole fraction', $
                     UNITS:'ppmv' }
  'hgt':     ATT = {  TYPE:'F', $
                 LONG_NAME:'altitude above geoid', $
                     UNITS:'km' }
  'hms':     ATT = {  TYPE:'L', $
                 LONG_NAME:'time in HHMMSS form' }
  'ifov':    ATT = {  TYPE:'B', $
               LONG_NAME:'instantaneous field of view index within scan line'}
  'julian_day': ATT = { TYPE:'L', $
                 LONG_NAME:'Day since 1st Jan 2000' }
  'lat':     ATT = {  TYPE:'F', $
             STANDARD_NAME:'latitude', $
                 LONG_NAME:'latitude of retrieved profile centre', $
                     UNITS:'degrees_north' }
  'lnd':     ATT = {  TYPE:'F', $
                 LONG_NAME:'land fraction', $
                     UNITS:'percent' }
  'lon':     ATT = {  TYPE:'F', $
             STANDARD_NAME:'longitude', $
                 LONG_NAME:'longitude of retrieved profile centre', $
                     UNITS:'degrees_east' }
  'n2o':     ATT = {  TYPE:'F', $
                 LONG_NAME:'nitrous oxide mole fraction', $
                     UNITS:'ppmv' }
  'nh3':     ATT = {  TYPE:'F', $
                 LONG_NAME:'ammonia mole fraction', $
                     UNITS:'ppmv' }
  'o3':      ATT = {  TYPE:'F', $
                 LONG_NAME:'ozone mole fraction', $
                     UNITS:'ppmv' }
  'orbit':   ATT = {  TYPE:'L', $
                 LONG_NAME:'Satellite orbit number' }
  'orbit_end': ATT = { TYPE:'L', $
                 LONG_NAME:'Orbit end time hhmmss' }
  'orbit_npix': ATT = { TYPE:'L', $
                 LONG_NAME:'No. pixels from orbit' }
  'orbit_start': ATT = { TYPE:'L', $
                 LONG_NAME:'Orbit start time hhmmss' }
  'poi':     ATT = {  TYPE:'F', $
                 LONG_NAME:'pointing correction', $
                     UNITS:'km' }
  'pre':     ATT = {  TYPE:'F', $
                 LONG_NAME:'pressure', $
                     UNITS:'hectopascals' }
  'refpre':  ATT = {  TYPE:'F', $
                 LONG_NAME:'reference pressure', $
                     UNITS:'hectopascals' }
  'sfcpre':  ATT = {  TYPE:'F', $
                 LONG_NAME:'surface pressure', $
                     UNITS:'hectopascals' }
  'sfctem':  ATT = {  TYPE:'F', $
                 LONG_NAME:'surface temperature', $
                     UNITS:'kelvin' }
  'so2':     ATT = {  TYPE:'F', $
                 LONG_NAME:'sulphur dioxide mole fraction', $
                     UNITS:'ppmv' }
  'sunrise': ATT = {  TYPE:'B', $
                 LONG_NAME:'sunrise 1, sunset 0' }
  'sza':     ATT = {  TYPE:'F', $
             STANDARD_NAME:'solar_zenith_angle', $
                 LONG_NAME:'solar zenith angle', $
                     UNITS:'degrees' }
  'tem':     ATT = {  TYPE:'F', $
                 LONG_NAME:'temperature', $
                     UNITS:'kelvin' }
  'time':    ATT = {  TYPE:'L', $
             STANDARD_NAME:'time', $
                 LONG_NAME:'time since midnight UT', $
                     UNITS:'milliseconds' }
  'ymd':     ATT = {  TYPE:'L', $
                 LONG_NAME:'date in yyyymmdd form' }
  'zen':     ATT = {  TYPE:'F', $
                 LONG_NAME:'satellite zenith angle', $
                     UNITS:'degrees' }
  ELSE: MESSAGE, 'F-NCV_DEF: Unrecognised variable: ' + VAR
ENDCASE

IF QAL NE '' THEN BEGIN
  CASE QAL OF
    '_csq':  ATT = { TYPE:'F', $
                LONG_NAME:ATT.LONG_NAME + $
                          ' retrieval chi-sq wrt a priori' }
    '_dfs':  ATT = { TYPE:'F', $
                LONG_NAME:ATT.LONG_NAME + $
                          ' retrieval degrees of freedom for signal' }
    '_inf':  ATT = { TYPE:'F', $
                LONG_NAME:ATT.LONG_NAME + $
                          ' retrieval information content', $
                    UNITS:'bits' }
    '_res':  ATT = { TYPE:'F', $
                LONG_NAME:ATT.LONG_NAME + $
                          ' retrieval vertical resolution scale factor' }
     '_sd':  ATT = { TYPE:'F', $
                LONG_NAME:ATT.LONG_NAME + $
                          ' retrieval standard deviation', $
                    UNITS:ATT.UNITS }
  ENDCASE
ENDIF

ATTLST = TAG_NAMES(ATT)

TYPE = ATT.TYPE
CASE TYPE OF
 'F': IF SCALAR THEN VID = NCDF_VARDEF ( NCID, NAME, /FLOAT ) $
                ELSE VID = NCDF_VARDEF ( NCID, NAME, DIMS, /FLOAT )
 'L': IF SCALAR THEN VID = NCDF_VARDEF ( NCID, NAME, /LONG ) $
                ELSE VID = NCDF_VARDEF ( NCID, NAME, DIMS, /LONG )
 'B': IF SCALAR THEN VID = NCDF_VARDEF ( NCID, NAME, /BYTE ) $
                ELSE VID = NCDF_VARDEF ( NCID, NAME, DIMS, /BYTE )
ENDCASE

FOR IATT = 1, N_ELEMENTS(ATTLST)-1 DO BEGIN
  ATTNAM = ATTLST[IATT]
  CASE ATTNAM OF
      'LONG_NAME': NCDF_ATTPUT, NCID, VID, ATTNAM, ATT.LONG_NAME
  'STANDARD_NAME': NCDF_ATTPUT, NCID, VID, ATTNAM, ATT.STANDARD_NAME
          'UNITS': NCDF_ATTPUT, NCID, VID, ATTNAM, ATT.UNITS
  ENDCASE
ENDFOR

CASE TYPE OF 
  'F': NCDF_ATTPUT, NCID, VID, '_FillValue', -999.0, /FLOAT
  'L': NCDF_ATTPUT, NCID, VID, '_FillValue', -999, /LONG
  'B': NCDF_ATTPUT, NCID, VID, '_FillValue', -1, /BYTE
ENDCASE

RETURN, VID

END
