; IDL program to plot MORSE Averaging Kernel matrix

avk = read_avk ( 'hiros_ch4.avk' )
nlev = avk.hdr.nlev
altlev = avk.hdr.levgrd
a = avk.pix.avk

set_plot, 'PS'
device, file='avk.eps', /encapsulated, xsize=20, ysize=10
!p.font = 0
!p.multi = [ 0, 2, 1 ] 

plot, [-0.1,1.1], [0, 60], /nodata, $
  title = 'AVK columns (delta-fn responses)', $
  xtitle='Response', ytitle='Altitude [km]'
for ilev = 0, nlev-1 do oplot, a[*,ilev], altlev
sum = fltarr(nlev)
for ilev = 0, nlev-1 do sum[ilev] = total(a[*,ilev])
oplot, sum, altlev, line=1

plot, [-0.1,1.1], [0, 60], /nodata, $
  title = 'AVK rows (contribution fns)', $
  xtitle='Response', ytitle='Altitude [km]'
for ilev = 0, nlev-1 do oplot, a[ilev,*], altlev
for ilev = 0, nlev-1 do sum[ilev] = total(a[ilev,*])
oplot, sum, altlev, line=1

device, /close
end
