FUNCTION READ_GRD, GRDFIL
;
; VERSION
;   25AUG22 AD Converted to Function
;   03DEC14 AD Original
;
; DESCRIPTION
;   Procedure to read RFM irreg.grid file
;
; ARGUMENTS
;   GRDFIL  String  I  Name of .grd file to be read
;
; RETURNS
;   Structure:
;   .NREG  Long       Number of regular grid points
;   .WNO1  Double     Wavenumber [cm-1] of 1st point in regular grid
;   .WNOD  Double     Wavenumber [cm-1] increment of regular grid
;   .NGRD  Long       Number of selected irregular grid points
;   .IDX   Long(NGRD) Indices of selected irregular grid points (0=WNO1)

; Open file
OPENR, LUN, GRDFIL, /GET_LUN
REC = ''
READF, LUN, REC    ; skip any initial record
REC = '!'
WHILE STRMID ( REC, 0, 1 ) EQ '!' DO READF, LUN, REC  ; skip header records
NREG = 0L
NGRD = 0L
WNO1 = 0.0D0
WNOD = 0.0D0
READF, LUN, NREG, NGRD, WNO1, WNOD
READF, LUN, REC
IDX = LONARR(NGRD)

IGRD = 0L
IHEX = 0
ITWO = 0
FOR IREG = 0L, NREG-1 DO BEGIN
  IF IREG MOD 200 EQ 0 THEN BEGIN
    READF, LUN, REC
    ICHAR = 0
  ENDIF
  IF IREG MOD 4 EQ 0 THEN BEGIN
    READS, STRMID(REC,ICHAR,1), IHEX, FORMAT='(Z)'
    ITWO = 8
    ICHAR = ICHAR + 1
  ENDIF 
  IF ( IHEX AND ITWO ) GT 0 THEN BEGIN
    IDX(IGRD) = IREG
    IGRD = IGRD + 1
  ENDIF
  ITWO = ITWO / 2
ENDFOR
IF IGRD NE NGRD THEN MESSAGE, 'F-READ_GRD: counting error'
FREE_LUN, LUN

RETURN, { NREG:NREG, $    ; Number of regular grid points
          WNO1:WNO1, $    ; Wavenumber [cm-1] of 1st point in regular grid
          WNOD:WNOD, $    ; Wavenumber [cm-1] increment of regular grid
          NGRD:NGRD, $    ; Number of selected irregular grid points
           IDX:IDX     }  ; Indices of selected irregular grid points (0=WNO1)

END
  
