FUNCTION READ_L2, NCFILE
;
; VERSION
    VERSID = '12OCT22' ; AD Original. 
;
; DESCRIPTION
;   IDL function to read Cubemap L2 netCDF file.
;   Returns file contents as a structure
;
; ARGUMENTS
;   NCFILE  String  I  Name of netCDF file to be read
;
; USAGE
;   eg l2 = READ_L2 ( 'hsdi_pt.nc' ) 

; Open netCDF file
NCID = NCDF_OPEN ( NCFILE ) 

; Get overall data structure
NCDATA = NCDF_INQUIRE ( NCID ) 

L2 = { } 

; Get Global Attributes
FOR IGATT = 0, NCDATA.NGATTS-1 DO BEGIN
  NAME = NCDF_ATTNAME ( NCID, IGATT, /GLOBAL ) 
  NCDF_ATTGET, NCID, NAME, VALUE, /GLOBAL
  L2 = CREATE_STRUCT ( NAME, VALUE, L2 )
ENDFOR

; Get Dimensions
FOR IDIM = 0, NCDATA.NDIMS-1 DO BEGIN
  NCDF_DIMINQ, NCID, IDIM, NAME, SIZE
  L2 = CREATE_STRUCT ( NAME, SIZE, L2 ) 
ENDFOR

; Get Data
FOR IVAR = 0, NCDATA.NVARS-1 DO BEGIN
  VAR = NCDF_VARINQ (NCID,IVAR)
  NAME = VAR.NAME
  NCDF_VARGET, NCID, IVAR, VALUE
  L2 = CREATE_STRUCT ( NAME, VALUE, L2 )
ENDFOR

NCDF_CLOSE, NCID

RETURN, L2

END

L2 = READ_L2 ( 'l2_hiros_pt.nc' )
end

