FUNCTION READ_RES, RESFIL, MMIC=MMIC, MPIX=MPIX
;
; VERSION
;   17JUN24 AD Orginal.
;
; DESCRIPTION
;   IDL function to read MORSE .res file
;
; ARGUMENTS
;   STRING  RESFIL  I  Name of .res file
;   INTEGER MMIC    I  (Optional, default=1) Microwindow# required 
;   INTEGER MPIX    I  (Optional, default=1) Pixel# required 
;
; RETURNS
;   RES(NPTS,NSWP)
;
; USAGE
;   res = read_res ( 'hiros_pt.res', MMIC=2 ) ; read MW#2
;   plot, res[*,0]  ; plot first residual for MW#2
;


IF NOT KEYWORD_SET(MMIC) THEN MMIC = 1
IF NOT KEYWORD_SET(MPIX) THEN MPIX = 1

OPENR, LUN, RESFIL, /GET_LUN

REC = ''
READF, LUN, REC  ; skip 2 header records
READF, LUN, REC

; Read No.pixels and No.microwindows
NPIX = 0
NMIC = 0
READF, LUN, NPIX, NMIC

FOR IPIX = 1, MPIX DO BEGIN

  READF, LUN, JPIX
  READF, LUN, REC   ;  header record
  READF, LUN, REC   ;  Pixel time/location data

  FOR IMIC = 1, NMIC DO BEGIN
    READF, LUN, REC
    READF, LUN, JMIC, NSWP, NPTS
    MASK = INTARR(NPTS)
    RES = FLTARR(NPTS,NSWP)
    Y = FLTARR(NPTS)
    FOR ISWP = 0, NSWP-1 DO BEGIN
      READF, LUN, JSWP
      READF, LUN, MASK
      READF, LUN, Y
      RES[*,ISWP] = Y
    ENDFOR
    IF IMIC EQ MMIC AND IPIX EQ MPIX THEN BREAK
  ENDFOR
ENDFOR  

FREE_LUN, LUN

RETURN, RES

END

