FUNCTION YMD, JDAY
;
; VERSION
;   20JUL21 AD Comment changes only
;   21DEC18 AD Original
;
; DESCRIPTION
;   Function to return YYYYMMDD string for Julian Day# (0 = '20000101')
;   Uses the modified Julian day used by EUMETSAT, for which day#0 corresponds
;   to day#2451545 in the IDL definition of Julian day#0=1 Jan -4713
;
; ARGUMENTS
;   JDAY  Long  I  Modified Julian day, 0= 1 Jan 2000
;
; RETURNS
;   String(8)  eg '20210721'

JDAY0 = 2451545L                        ; = JULDAY(1,1,2000)
CALDAT, JDAY+JDAY0, IM, ID, IY          ; standard IDL procedure
RETURN, STRING(IY,IM,ID,FORMAT='(I4,2I2.2)')
END

